using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Borland.Eco.Handles;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;

namespace [!Namespace]
{
	/// <summary>
	/// Summary description for [!FormName].
	/// </summary>
	public class [!FormName] : System.Web.UI.Page
	{
		protected Borland.Eco.Handles.ReferenceHandle rhRoot;
[!if=(EcoSpaceClassName, "Borland.Eco.Handles.EcoSpace")]
// ToDo replace Borland.Eco.Handles.EcoSpace with actual type of ecospace in project
[!endif]
		private [!EcoSpaceClassName] m_EcoSpace;
		protected [!EcoSpaceClassName] EcoSpace
		{
			get
			{
				if (m_EcoSpace == null)
				{
					m_EcoSpace = EcoSpaceProvider.GetEcoSpace();
					rhRoot.EcoSpace = m_EcoSpace;
					// Set additional root handles here and in DoneWithEcoSpace
				}
				return m_EcoSpace;
			}
		}

		private void DoneWithEcoSpace()
		{
			if (m_EcoSpace == null)
				return;

			rhRoot.EcoSpace = null;
			rhRoot.SetElement(null);
			// Clear all other references to m_EcoSpace or its contents here.
			// Otherwise it is not safe to return it to a pool.

			EcoSpaceProvider.ReturnEcoSpace(m_EcoSpace);
			m_EcoSpace = null;
		}

		private void Page_Load(object sender, System.EventArgs e)
		{
			EcoSpace.Active = true;
			string id = Request.Params["RootId"];
			if ((id != null) && (id != ""))
				rhRoot.SetElement(ObjectForId(id));
			if (!IsPostBack)
				DataBind();
			// Put user code to initialize the page here
		}

		private void Page_Unload(object sender, System.EventArgs e)
		{
			DoneWithEcoSpace();
		}

		public override void DataBind()
		{
			ElementHandle.EnsureAllBindingLists();
			base.DataBind();
		}


		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// Required for Web Form Designer support
			//
			InitializeComponent();
			base.OnInit(e);
		}

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.Load += new System.EventHandler(this.Page_Load);
			this.Unload += new System.EventHandler(this.Page_Unload);
			this.rhRoot = new Borland.Eco.Handles.ReferenceHandle();
			//
			// rhRoot
			//
			this.rhRoot.Enabled = true;
			this.rhRoot.EcoSpace = null;
			this.rhRoot.StaticValueTypeName = null;
			this.rhRoot.Variables = null;
[!if=(EcoSpaceClassName, "Borland.Eco.Handles.EcoSpace")]
[!else]
			this.rhRoot.EcoSpaceType = typeof([!Namespace].[!EcoSpaceClassName]);
[!endif]

		}
		#endregion

		#region Utility methods
		protected void UpdateDatabase()
		{
			IPersistenceService persistenceService = EcoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
			IDirtyListService dirtyListService = EcoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
			persistenceService.UpdateDatabaseWithList(dirtyListService.AllDirtyObjects());
		}

		protected string IdForObject(IObject obj)
		{
			IExternalIdService idService = EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
			return idService.IdForObject(obj);
		}

		protected IObjectInstance ObjectForId(string id)
		{
			IExternalIdService idService = EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
			return idService.ObjectForId(id);
		}
		#endregion

		#region DataGrid Events

		/*
		The following code is useful if the form contains a System.Web.UI.Datagrid;
		It assumes that the elementhandle acting as a datasource has
		AddExternalId = true, and that datagrid.DataKeyField = "ExternalId"
		*/

		protected void DataGrid_DeleteCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			DataGrid dataGrid = (DataGrid)source;
			string id = dataGrid.DataKeys[e.Item.ItemIndex].ToString();
			IObject toDelete = ObjectForId(id);
			if (toDelete != null)
				toDelete.Delete();
			UpdateDatabase();
			DataBind();
		}

		protected void DataGrid_EditCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			((DataGrid)source).EditItemIndex = e.Item.ItemIndex;
			DataBind();
		}

		protected void DataGrid_UpdateCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			DataGrid dataGrid = (DataGrid)source;
			string id = dataGrid.DataKeys[e.Item.ItemIndex].ToString();
			dataGrid.DataBind(); // To set DataSource
			ElementHandle eh = (ElementHandle)dataGrid.DataSource;
			object row = eh.RenderElement(ObjectForId(id));
			for (int colIndex = 0; colIndex <  dataGrid.Columns.Count; colIndex++)
			{
				BoundColumn col = dataGrid.Columns[colIndex] as BoundColumn;
				if ((col != null) && !col.ReadOnly)
					eh.SetRenderedElementProperty(row, col.DataField, ((TextBox)e.Item.Cells[colIndex].Controls[0]).Text, true);
			}
			UpdateDatabase();
			dataGrid.EditItemIndex = -1;
			DataBind();
		}

		protected void DataGrid_CancelCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			((DataGrid)source).EditItemIndex = -1;
			DataBind();
		}
		#endregion
	}
}
